# function finds the reference pattern of each respondent group
# Function requires Stat_pat1, Stat_pat2, Stat_pat3, Stat_pat4, and Ref_creat1 function as ready for call
# returns the reference vectors corrosponding to each separate respondent group
Ref_creat<-function(Lis1,len)
{
  group = length(Lis1)
  Ref = matrix(data = 0, nrow = group, ncol = len)
  Vi = matrix(data = 0, nrow = group, ncol = len)
  for(i in 1:group)
  {
    S = Stat_pat1(Lis1[[i]]) # frequency count
    T = Stat_pat2(Lis1[[i]]) # Creation of SDA
    U = Stat_pat3(T)         # Intermediate array
    V = Stat_pat4(S)         # Creation of PDA
    Vi[i,] = V
    Ref[i,] = Ref_creat1(V,U) #Decision making procedure to find reference vector
  }
  return(Ref)
}